/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigAppSpaceNode;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWNewAppSpaceDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    protected JTextField m_nameTextField = null;
    protected JTextArea m_descriptionTextArea = null;
    protected JButton m_createButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;
    private VWConfigBaseNode m_parentFolderNode = null;
    private VWConfigAppSpaceNode m_newAppSpaceNode = null;

    public VWNewAppSpaceDialog(Frame parentFrame, VWConfigBaseNode parentFolderNode) {
        super(parentFrame);
        this.m_parentFolderNode = parentFolderNode;
        this.initialize();
    }

    public VWConfigAppSpaceNode getNewNode() {
        return this.m_newAppSpaceNode;
    }

    public void releaseResources() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_createButton != null) {
            this.m_createButton.removeActionListener(this);
            this.m_createButton.removeAll();
            this.m_createButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_parentFolderNode = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.setVisible(false);
        } else if (obj == this.m_createButton) {
            String nameText = this.m_nameTextField.getText();
            if (nameText == null || nameText.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.NameCanNotBeNull, null, 1, null);
            } else if (nameText.startsWith("F_", 0) || nameText.startsWith("f_", 0)) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidConfigName.toString(nameText), VWResource.ErrorMessage, 0);
            } else if (this.createAppSpace()) {
                this.setVisible(false);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc098.htm");
        } else if (obj == this.m_nameTextField) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        this.setCreateButtonState();
    }

    protected void initialize() {
        try {
            this.setTitle(VWResource.NewApplicationSpace);
            Dimension dim = VWStringUtils.stringToDimension("445,275");
            if (dim == null) {
                dim = new Dimension(400, 250);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.createMainPanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(4, 0, 4, 8);
            JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.ApplicationSpaceName));
            VWAccessibilityHelper.setAccessibility(nameLabel, this, VWResource.ApplicationSpaceName, VWResource.ApplicationSpaceName);
            mainPanel.add((Component)nameLabel, gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_nameTextField = new JTextField();
            VWAccessibilityHelper.setAccessibility(this.m_nameTextField, this, VWResource.ApplicationSpaceNameTextField, VWResource.ApplicationSpaceNameTextField);
            VWAccessibilityHelper.setLabelFor(nameLabel, this.m_nameTextField);
            mainPanel.add((Component)this.m_nameTextField, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.Description));
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.Description, VWResource.Description);
            mainPanel.add((Component)descriptionLabel, gbConst);
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.DescriptionTextArea, VWResource.DescriptionTextArea);
            VWAccessibilityHelper.setLabelFor(descriptionLabel, this.m_descriptionTextArea);
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), gbConst);
            this.m_nameTextField.addKeyListener(this);
            this.m_nameTextField.addActionListener(this);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.m_createButton = new JButton(VWResource.Create);
            this.m_createButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_createButton, this, VWResource.Create, VWResource.Create);
            buttonPanel.add(this.m_createButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.Cancel, VWResource.Cancel);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            buttonPanel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_createButton);
            this.setCreateButtonState();
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void setCreateButtonState() {
        if (this.m_createButton == null) {
            return;
        }
        boolean bEnable = true;
        if (this.m_nameTextField != null) {
            String tempString = this.m_nameTextField.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_createButton.isEnabled() != bEnable) {
            this.m_createButton.setEnabled(bEnable);
        }
    }

    private boolean createAppSpace() {
        try {
            String appSpaceName = this.m_nameTextField.getText();
            VWConfigRegionNode regionNode = (VWConfigRegionNode)this.m_parentFolderNode;
            VWApplicationSpaceDefinition appSpaceDef = regionNode.getSystemConfiguration().createApplicationSpaceDefinition(appSpaceName);
            appSpaceDef.setDescription(this.m_descriptionTextArea.getText());
            this.m_newAppSpaceNode = new VWConfigAppSpaceNode(regionNode.getSessionInfo(), appSpaceDef, regionNode.getServiceName(), regionNode.getRegionID(), regionNode.getSystemConfiguration());
            return true;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            return false;
        }
    }
}

